
***Creation input files for Pareto interpolation for income series ***

*global projdir "W:\brtrd\Projet wealth_income\Imputation_gperc\Income"
global projdir "C:\Users\G839276\Dropbox\WIDFrance\Papers\GGP2017DINA\GGP2017DINAAppendixC\DataFiles\Results"
*
global projdir "C:\Users\Bertrand\Dropbox\WIDFrance\Papers\GGP2017DINA\GGP2017DINAAppendixC\DataFiles\Results"


cd "$projdir"

/*** 1st part : Programs ***/
capture program drop interpolation_income
program interpolation_income
	args typeincome year1 year2
	
	clear
	import excel "$projdir\Pareto interpolations\averageincome_year.xlsx", sheet("averages")  cellrange(A2:L47)  firstrow clear
	keep year `typeincome'
		
	tempfile temp1
	save `temp1',replace
	use "$projdir\dperc\dpercr_`typeincome'", clear
	keep if sex==0
	keep year dperc share_dperc
	sort year dperc
	merge m:1 year using `temp1'
	erase `temp1'
	keep if _merge==3
	drop _merge
	g pop_share_above=1-dperc/100
	replace pop_share = round(pop_share,0.001)
	replace pop_share=0.005 if dperc==995
	replace pop_share=0.001 if dperc==999
		
	bys year: egen double sum_share=sum(share)
	summ sum_share,de
	*rescaling share to 100 because of roundings
	replace share=share*1/sum_share
	drop sum_share
	g inc_dperc = share*`typeincome'
	
	gsort year - dperc
	bys year: g double sum_ytop= sum(inc_dperc)
	bys year: g double share_top= sum(share)
	*Correction for rounding
	bys year: egen sum_cumul=sum(inc_dperc)
	replace sum_ytop=sum_ytop*`typeincome'/sum_cumul
	drop sum_cumul
	
	g ytop= sum_ytop/pop_share
	tempfile temp1
	keep year dperc ytop sum_ytop `typeincome' share_dperc share_top
	save `temp1',replace

	use "$projdir\gperc\gpercr_`typeincome'", replace
	keep if sex==0 & inlist(gperc,0,10,20,30,40,50,60,70,80,90,95,990,9990,99990)
	replace gperc=99 if gperc==990
	replace gperc=999 if gperc==9990
	replace gperc=9999 if gperc==99990
	keep year gperc thr b y0 ymean  
	rename gperc dperc
	merge 1:m year dperc using `temp1'
	sort year dperc
	keep if year >=`year1' & year <= `year2'
	keep if !(_merge==1)
	drop _merge
	replace thr=0 if missing(thr) & dperc==0
	g p = dperc/100
	replace p=0.999 if dperc==999
	drop if dperc==995
	replace share_dperc=share_top-share_top[_n+1] if dperc==99
	*rescaling for rounding
	replace thr=thr*`typeincome'/ymean
	drop ymean	
	sort year dperc
	bys year: g double a=(1-((ln(share_top/share_top[_n+1]))/(ln((1-p)/(1-p[_n+1])))))^(-1)
	bys year: g double ratio_p=sum_ytop/sum_ytop[_n+1]
	reshape wide p thr b `typeincome' ytop y0 sum_ytop a ratio_p share_dperc share_top, i(dperc) j(year)

	**** Interpolations
	capture drop slope*
	capture drop a_*
	g slope_y0=(y0`year2'-y0`year1')/(`year2'-`year1')
	g  a_y0 = (y0`year1'-`year1'*slope_y0)

	local year_min=`year1'+1
	local year_max=`year2'-1
	forvalue year = `year_min'/`year_max'{
		replace y0`year'=a_y0+slope_y0*`year'
		replace p`year'=0.999 if dperc==999
	}	

	preserve 
		keep y0*
		keep if _n==1
		g v=1
		reshape long y0, i(v) j(year)
		g p=round(y0,.001)
		keep year p
		g thr = 0
		g b=.
		save y0_`typeincome'_`year1'_`year2',replace
	restore
	drop y0* slope_y0 a_y0
	save temp_`typeincome'_`year1'_`year2',replace
end


capture program drop interpolation_income2
program interpolation_income2
	args typeincome year1 year2
	capture drop a_* 
	capture drop slope*
	keep dperc p* thr* b* `typeincome'* a* ytop* ratio_p* share* sum_ytop*
	reshape long p thr b `typeincome' a ytop ratio_p share_dperc share_top sum_ytop, i(dperc) j(year)
	sort year dperc
	order dperc year `typeincome' p thr a b ytop ratio_p share_dperc share_top sum_ytop
	rename `typeincome' average
	replace b=. if b==0
	replace thr=0 if missing(thr)
	append using  y0_`typeincome'_temp
	sort year p dperc
	bys year: g t=_n
	bys year: g tb=_N
	xtset year t
	replace average = L.average if missing(average) &  p>0
	replace average = F.average if missing(average) &  p>0 & t<tb
	drop t tb
	sort year p
	replace dperc=round(100*p,1) if missing(dperc)
	keep if year>=`year1' & year <=`year2'
	bys year: gen t=p if missing(a) & !(dperc==999)
	bys year: egen t2=min(t)
	drop t 
	
	replace ytop = average/(1-p) if missing(ytop) & p==t2
	bys year p: drop if _n==2

	bys year: gen yint = (((1-p)*(ytop))-(1-p[_n+1])*(ytop[_n+1]))/(p[_n+1]-p)
	bys year: replace yint = ytop if d==999
	
	sort year p
	bys year: replace sum_ytop=sum_ytop[_n-1] if missing(sum_ytop) & p<=t2
	bys year: replace share_top=share_top[_n-1] if missing(share_top) & p<=t2
	drop if p==t2 & (missing(yint))
	reshape  wide average thr a b t2 ratio_p ytop share_dperc dperc yint sum_ytop share_top, i(p) j(year)
	br p dperc* thr* t2* yint* sum_ytop* ytop*
	
	forvalue year=`year1'/`year2'{
		replace yint`year'=(sum_ytop`year'-sum_ytop`year'[_n+1])/(p[_n+1]-p) if missing(yint`year')
		replace yint`year'=yint`year'[_n-1] if missing(yint`year')
		replace t2`year'=t2`year'[_n-1] if missing(t2`year')
		replace thr`year'=0 if (missing(thr`year') & p<=t2`year' & !missing(t2`year') )
	}
	br p dperc* thr* t2* yint* sum_ytop*
	
	local year_min=`year1'+1
	local year_max=`year2'-1
	forvalue year = `year_min'/`year_max'{
		local yearn1 = `year'-1
		*interpolation missing threshold
		replace thr`year' = thr`yearn1'*0.5*(yint`year'[_n-1]/yint`yearn1'[_n-1] + yint`year'/yint`yearn1') if (p>t2`year'&!missing(t2`year') & t2`year'>=t2`yearn1')
		replace b`year' =  ytop`year'/thr`year' if (p>t2`year'&!missing(t2`year') & t2`year'>=t2`yearn1')
		
		replace thr`year' = thr`yearn1'*0.5*(yint`year'[_n-1]/yint`yearn1'[_n-1] + yint`year'/yint`yearn1') if (p>t2`yearn1'&!missing(t2`year') & t2`year'<t2`yearn1')
		replace b`year' =  ytop`year'/thr`year' if (p>t2`yearn1'&!missing(t2`year') & t2`year'<t2`yearn1')
		
	}
	keep p* thr* b* a* ytop* share* dperc* yint* sum_ytop* t2*
	reshape long thr b a average ytop share_dperc dperc yint sum_ytop t2, i(p) j(year)
	sort year p
	order year p thr a b average ytop share_dperc dperc yint sum_ytop t2
		
	*testing for consistency
	capture drop int_corr*
	gen int_corr = (p>=t2 & thr<yint[_n-1])
	*bys year: egen int_corr2 = max(int_corr)
	reshape  wide  thr* b* a* ytop* share* dperc* yint* sum_ytop* t2*  int_corr*, i(p) j(year)
	br p dperc* thr* b* t2* yint* sum_ytop* ytop* int_corr*
	
	local year_min=`year1'+1
	local year_max=`year2'-1
	forvalue year = `year_min'/`year_max'{
		local yearn1 = `year'-1
		replace thr`year' = thr`yearn1'*(0.9*yint`year'[_n-1]/yint`yearn1'[_n-1] + 0.1*yint`year'/yint`yearn1') if (int_corr`year'==1)
		replace b`year' =  ytop`year'/thr`year' if (int_corr`year'==1)
	}
	*forvalue year = `year_min'/`year_max'{
	*	local yearn1 = `year'-1
		*taking into account correction
	*	replace thr`year' = thr`yearn1'*0.5*(yint`year'[_n-1]/yint`yearn1'[_n-1] + yint`year'/yint`yearn1') if (p>t2`year'&!missing(t2`year') & t2`year'>=t2`yearn1' & int_corr2`year'==1 & !(int_corr`year'==1))
	*	replace b`year' =  ytop`year'/thr`year' if (p>t2`year'&!missing(t2`year') & t2`year'>=t2`yearn1' & int_corr2`year'==1 & !(int_corr`year'==1))
	*	
	*	replace thr`year' = thr`yearn1'*0.5*(yint`year'[_n-1]/yint`yearn1'[_n-1] + yint`year'/yint`yearn1') if (p>t2`yearn1'&!missing(t2`year') & t2`year'<t2`yearn1' & int_corr2`year'==1 & !(int_corr`year'==1))
	*	replace b`year' =  ytop`year'/thr`year' if (p>t2`yearn1'&!missing(t2`year') & t2`year'<t2`yearn1' & int_corr2`year'==1 & !(int_corr`year'==1))
	*}
	
	keep p* thr* b* a* ytop* share* dperc* yint* sum_ytop* t2* 
	reshape long thr b a average ytop share_dperc dperc yint sum_ytop t2, i(p) j(year)
	sort year p
	order year p thr a b average ytop share_dperc dperc yint sum_ytop t2
	
	
	
	
	
	replace b=. if b==0
	replace thr=0 if missing(thr)
	sort year p thr
	drop if missing(t2)
	sort year p thr
	
	bys year: g t=_n
	bys year: g tb=_N
	xtset year t
	replace average = L.average if missing(average) &  p>0
	replace average = F.average if missing(average) &  p>0 & t<tb
	drop t tb
	/* To produce files compatible with the website http://apps.wid.world/gpinter/ */
	keep if p>=t2
	drop if thr==0 & p>t2
	keep year average p thr b
	order year average p thr b
	save temp_fin_`typeincome'_`year1'_`year2',replace
end

capture program drop export_results
program export_results
	args typeincome year
	preserve
		keep if year==`year'
		export excel using "$projdir\Pareto interpolations\for_interpolation_byyear_`typeincome'.xlsx", sheet("`year'")  firstrow(variables) sheetmodify
	restore
end


capture program drop complete
program complete
	args typeinc 
	interpolation_income `typeinc' 1970 1975
	interpolation_income `typeinc' 1975 1979
	interpolation_income `typeinc' 1979 1984
	interpolation_income `typeinc' 1984 1988
	interpolation_income `typeinc' 1988 1990

	clear
	use y0_`typeinc'_1970_1975,replace
	append using y0_`typeinc'_1975_1979
	append using y0_`typeinc'_1979_1984
	append using y0_`typeinc'_1984_1988
	append using y0_`typeinc'_1988_1990
	*drop if year > 1989
	*drop if inlist(year, 1970,1975,1979,1984,1988)
	save y0_`typeinc'_temp,replace

	erase y0_`typeinc'_1970_1975.dta 
	erase y0_`typeinc'_1975_1979.dta
	erase y0_`typeinc'_1979_1984.dta
	erase y0_`typeinc'_1984_1988.dta
	erase y0_`typeinc'_1988_1990.dta

	clear
	use temp_`typeinc'_1970_1975,replace
	merge m:1 dperc using temp_`typeinc'_1975_1979
	keep if _merge==3
	drop _merge
	merge m:1 dperc using temp_`typeinc'_1979_1984
	keep if _merge==3
	drop _merge
	merge m:1 dperc using temp_`typeinc'_1984_1988
	keep if _merge==3
	drop _merge
	merge m:1 dperc using temp_`typeinc'_1988_1990
	keep if _merge==3
	drop _merge

	preserve	
	interpolation_income2 `typeinc' 1970 1975
	restore
	preserve
	interpolation_income2 `typeinc' 1975 1979
	restore
	preserve
	interpolation_income2 `typeinc' 1979 1984
	restore
	preserve
	interpolation_income2 `typeinc' 1984 1988
	restore
	preserve
	interpolation_income2 `typeinc' 1988 1990
	restore

	clear
	use temp_fin_`typeinc'_1970_1975,replace
	append using temp_fin_`typeinc'_1975_1979
	append using temp_fin_`typeinc'_1979_1984
	append using temp_fin_`typeinc'_1984_1988
	append using temp_fin_`typeinc'_1988_1990
	order year	average	p	thr	b

	erase temp_`typeinc'_1970_1975.dta 
	erase temp_`typeinc'_1975_1979.dta
	erase temp_`typeinc'_1979_1984.dta
	erase temp_`typeinc'_1984_1988.dta
	erase temp_`typeinc'_1988_1990.dta
	erase temp_fin_`typeinc'_1970_1975.dta 
	erase temp_fin_`typeinc'_1975_1979.dta
	erase temp_fin_`typeinc'_1979_1984.dta
	erase temp_fin_`typeinc'_1984_1988.dta
	erase temp_fin_`typeinc'_1988_1990.dta

	forvalue i=1971/1974{
	export_results `typeinc' `i'
	}
	forvalue i=1976/1978{
	export_results `typeinc' `i'
	}
	forvalue i=1980/1983{
	export_results `typeinc' `i'
	}
	forvalue i=1985/1987{
	export_results `typeinc' `i'
	}
	export_results `typeinc' 1989
	*erase y0_`typeinc'_temp.dta
end



capture program drop interpolation_ratio
program define interpolation_ratio
	args year1 year2
	capture drop slope* /*a_**/
	g slope_ratio=(ratio_inc`year2'-ratio_inc`year1')/(`year2'-`year1')
	g  a_ratio = (ratio_inc`year1'-`year1'*slope_ratio)
	local year_min=`year1'+1
	local year_max=`year2'-1

	forvalue year = `year_min'/`year_max'{
		replace ratio_inc`year'=a_ratio+slope_ratio*`year'
		replace trav_FICN_2559`year'=ratio_inc`year'*trav_FICN_all`year'	
	}
	capture drop slope* 
	capture drop a_*
end



capture program drop interpolation_income_b
program interpolation_income_b
	args typeincome year1 year2
	
	/** To be launched the 1st time **
	/*** 0- Labor factor income for the 25-59 from national accounts factor income (all pop)***/
	/*** Writting the value in the Excel file averageincome_year.xlsx ***/
	if("`typeincome'"=="trav_FICN"){
		clear
		import excel "$projdir\Pareto interpolations\averageincome_year.xlsx", sheet("averages")  cellrange(A2:K47)  firstrow clear
		keep year `typeincome'_all
		tempfile temp2
		save `temp2',replace
		use "$projdir\gperc\gpercr`typeincome'", replace
		keep if sex==0
		keep year ymean pop
		bys year ymean pop: keep if _n==1
		rename ymean trav_FICN_2559
		rename pop pop2559
		merge m:1 year using `temp2'
		drop _merge
		g ratio_inc=trav_FICN_2559/trav_FICN_all
												
		/*** Interpolation ratio_inc ***/
		g v=1
		reshape wide trav* pop* ratio* , i(v) j(year)
			
		interpolation_ratio 1970 1975
		interpolation_ratio 1975 1979
		interpolation_ratio 1979 1984
		interpolation_ratio 1984 1988
		interpolation_ratio 1988 1990
		interpolation_ratio 1991 1994
			
		replace ratio_inc2013=ratio_inc2012
		replace ratio_inc2014=ratio_inc2012
		replace trav_FICN_25592013=ratio_inc2013*trav_FICN_all2013
		replace trav_FICN_25592014=ratio_inc2014*trav_FICN_all2014
			
		reshape long trav_FICN_2559 trav_FICN_all pop2559 ratio_inc, i(v) j(year)
		mkmat trav_FICN_2559, matrix(FICN)
		putexcel L3=matrix(FICN)   using "$projdir\Pareto interpolations\averageincome_year.xlsx", sheet("averages") modify
	}
	*** end of writting ***/
	clear
	import excel "$projdir\Pareto interpolations\averageincome_year.xlsx", sheet("averages")  cellrange(A2:L47)  firstrow clear
	drop trav_FICN_all
	keep year `typeincome'
		
	tempfile temp1
	save `temp1',replace
	use "$projdir\dperc\dpercr`typeincome'", clear
	keep if sex==0
	keep year dperc share_dperc
	sort year dperc
	merge m:1 year using `temp1'
	erase `temp1'
	keep if _merge==3
	drop _merge
	g pop_share_above=1-dperc/100
	replace pop_share = round(pop_share,0.001)
	replace pop_share=0.005 if dperc==995
	replace pop_share=0.001 if dperc==999
	
	bys year: egen double sum_share=sum(share)
	summ sum_share,de
	*rescaling share to 100 because of roundings
	replace share=share*1/sum_share
	drop sum_share
	g inc_dperc = share*`typeincome'
	
	gsort year - dperc
	bys year: g double sum_ytop= sum(inc_dperc)
	bys year: g double share_top= sum(share)
	*Correction for rounding
	bys year: egen sum_cumul=sum(inc_dperc)
	replace sum_ytop=sum_ytop*`typeincome'/sum_cumul
	drop sum_cumul	
	g ytop= sum_ytop/pop_share

	tempfile temp1
	keep year dperc ytop sum_ytop `typeincome' share_dperc share_top
	save `temp1',replace

	use "$projdir\gperc\gpercr`typeincome'", replace
	keep if sex==0 & inlist(gperc,0,10,20,30,40,50,60,70,80,90,95,990,9990,99990)
	replace gperc=99 if gperc==990
	replace gperc=999 if gperc==9990
	replace gperc=9999 if gperc==99990
	keep year gperc thr b y0 ymean  
	rename gperc dperc
	merge 1:m year dperc using `temp1'
	sort year dperc
	keep if year >=`year1' & year <= `year2'
	keep if !(_merge==1)
	drop _merge
	replace thr=0 if missing(thr) & dperc==0
	g p = dperc/100
	replace p=0.999 if dperc==999
	drop if dperc==995
	replace share_dperc=share_top-share_top[_n+1] if dperc==99
	*rescaling
	replace thr=thr*`typeincome'/ymean
	drop ymean
	sort year dperc
	bys year: g double a=(1-((ln(share_top/share_top[_n+1]))/(ln((1-p)/(1-p[_n+1])))))^(-1)
	bys year: g double ratio_p=sum_ytop/sum_ytop[_n+1]
	reshape wide p thr b `typeincome' ytop y0 sum_ytop a ratio_p share_dperc share_top, i(dperc) j(year)
	
	**** Interpolations
	capture drop slope*
	capture drop a_*		
	g slope_y0=(y0`year2'-y0`year1')/(`year2'-`year1')
	g  a_y0 = (y0`year1'-`year1'*slope_y0)

	local year_min=`year1'+1
	local year_max=`year2'-1

	forvalue year = `year_min'/`year_max'{
		replace y0`year'=a_y0+slope_y0*`year'
		replace p`year'=0.999 if dperc==999
	}	

	preserve 
		keep y0*
		keep if _n==1
		g v=1
		reshape long y0, i(v) j(year)
		g p=round(y0,.001)
		keep year p
		g thr = 0
		g b=.
		save y0_`typeincome'_`year1'_`year2',replace
	restore
	drop y0* slope_y0 a_y0
	save temp_`typeincome'_`year1'_`year2',replace
end


capture program drop complete2
program complete2
	args typeinc 
	interpolation_income_b `typeinc' 1970 1975
	interpolation_income_b `typeinc' 1975 1979
	interpolation_income_b `typeinc' 1979 1984
	interpolation_income_b `typeinc' 1984 1988
	interpolation_income_b `typeinc' 1988 1990

	clear
	use y0_`typeinc'_1970_1975,replace
	append using y0_`typeinc'_1975_1979
	append using y0_`typeinc'_1979_1984
	append using y0_`typeinc'_1984_1988
	append using y0_`typeinc'_1988_1990
	*drop if year > 1989
	*drop if inlist(year, 1970,1975,1979,1984,1988)
	save y0_`typeinc'_temp,replace

	erase y0_`typeinc'_1970_1975.dta 
	erase y0_`typeinc'_1975_1979.dta
	erase y0_`typeinc'_1979_1984.dta
	erase y0_`typeinc'_1984_1988.dta
	erase y0_`typeinc'_1988_1990.dta

	clear
	use temp_`typeinc'_1970_1975,replace
	merge m:1 dperc using temp_`typeinc'_1975_1979
	keep if _merge==3
	drop _merge 
	merge m:1 dperc using temp_`typeinc'_1979_1984
	keep if _merge==3
	drop _merge
	merge m:1 dperc using temp_`typeinc'_1984_1988
	keep if _merge==3
	drop _merge
	merge m:1 dperc using temp_`typeinc'_1988_1990
	keep if _merge==3
	drop _merge

	preserve	
	interpolation_income2 `typeinc' 1970 1975
	restore
	preserve
	interpolation_income2 `typeinc' 1975 1979
	restore
	preserve
	interpolation_income2 `typeinc' 1979 1984
	restore
	preserve
	interpolation_income2 `typeinc' 1984 1988
	restore
	preserve
	interpolation_income2 `typeinc' 1988 1990
	restore
	
	clear
	use temp_fin_`typeinc'_1970_1975,replace
	append using temp_fin_`typeinc'_1975_1979
	append using temp_fin_`typeinc'_1979_1984
	append using temp_fin_`typeinc'_1984_1988
	append using temp_fin_`typeinc'_1988_1990
	order year	average	p thr b

	erase temp_`typeinc'_1970_1975.dta 
	erase temp_`typeinc'_1975_1979.dta
	erase temp_`typeinc'_1979_1984.dta
	erase temp_`typeinc'_1984_1988.dta
	erase temp_`typeinc'_1988_1990.dta
	erase temp_fin_`typeinc'_1970_1975.dta 
	erase temp_fin_`typeinc'_1975_1979.dta
	erase temp_fin_`typeinc'_1979_1984.dta
	erase temp_fin_`typeinc'_1984_1988.dta
	erase temp_fin_`typeinc'_1988_1990.dta

	forvalue i=1971/1974{
	export_results `typeinc' `i'
	}
	forvalue i=1976/1978{
	export_results `typeinc' `i'
	}
	forvalue i=1980/1983{
	export_results `typeinc' `i'
	}
	forvalue i=1985/1987{
	export_results `typeinc' `i'
	}
	export_results `typeinc' 1989
	*erase y0_`typeinc'_temp.dta
end

/** Adding 2013 and 2014 **/
capture program drop interpolation_income3
program interpolation_income3
	args typeincome 
	
	import excel "$projdir\Pareto interpolations\averageincome_year.xlsx", sheet("averages")  cellrange(A2:L47)  firstrow clear
	drop trav_FICN_all
	keep year `typeincome'
	tempfile temp1
	save `temp1',replace
	if(inlist("`typeincome'","irpp","irpp_equal","irpp_foy","pretaxCN","pretaxCN_equal","pretaxCN_foy")){
		use "$projdir\dperc\dpercr_`typeincome'", clear
	}
	if(inlist("`typeincome'","cap","trav_FICN","trav_pretaxCN","trav_pretaxCN_equal")){
		use "$projdir\dperc\dpercr`typeincome'", clear
	}
	keep if sex==0
	keep year dperc share_dperc
	sort year dperc
	merge m:1 year using `temp1'
	erase `temp1'
	keep if _merge==3
	drop _merge
	g pop_share_above=1-dperc/100
	replace pop_share = round(pop_share,0.001)
	replace pop_share=0.005 if dperc==995
	replace pop_share=0.001 if dperc==999

		bys year: egen double sum_share=sum(share)
		summ sum_share,de
		*rescaling share to 100 because of roundings
		replace share=share*1/sum_share
		drop sum_share
		g inc_dperc = share*`typeincome'
		
		gsort year - dperc
		bys year: g double sum_ytop= sum(inc_dperc)
		bys year: g double share_top= sum(share)
		*Correction for rounding
		bys year: egen sum_cumul=sum(inc_dperc)
		replace sum_ytop=sum_ytop*`typeincome'/sum_cumul
		drop sum_cumul
		g ytop= sum_ytop/pop_share

	tempfile temp1
	keep year dperc ytop sum_ytop `typeincome' share_dperc share_top
	save `temp1',replace

	if(inlist("`typeincome'","irpp","irpp_equal","irpp_foy","pretaxCN","pretaxCN_equal","pretaxCN_foy")){
		use "$projdir\gperc\gpercr_`typeincome'", replace
	}
	if(inlist("`typeincome'","cap","trav_FICN","trav_pretaxCN","trav_pretaxCN_equal")){
		use "$projdir\gperc\gpercr`typeincome'", replace
	}
	br
	keep if sex==0 & inlist(gperc,0,10,20,30,40,50,60,70,80,90,95,990,9990,99990)
	replace gperc=99 if gperc==990
	replace gperc=999 if gperc==9990
	replace gperc=9999 if gperc==99990
	keep year gperc thr b y0 ymean
	rename gperc dperc
	merge 1:m year dperc using `temp1'
	sort year dperc
	keep if inlist(year,2012,2013,2014)
	keep if !(_merge==1)
	drop _merge
	replace thr=0 if missing(thr) & dperc==0
	g p = dperc/100
	replace p=round(p,0.001)
	replace p=0.999 if dperc==999
	drop if dperc==995
	replace share_dperc=share_top-share_top[_n+1] if dperc==99
	*rescaling
	replace thr=thr*`typeincome'/ymean
	drop ymean
		
		sort year dperc
		bys year: g double a=(1-((ln(share_top/share_top[_n+1]))/(ln((1-p)/(1-p[_n+1])))))^(-1)
		bys year: g double ratio_p=sum_ytop/sum_ytop[_n+1]
		reshape wide p thr b `typeincome' ytop y0 sum_ytop a ratio_p share_dperc share_top, i(dperc) j(year)
		/* y0 for 2013 and 2014 are set to 2012 values */
		replace y02013=y02012
		replace y02014=y02012

		
		preserve 
			keep y0*
			keep if _n==1
			g v=1
			reshape long y0, i(v) j(year)
			g p=round(y0,.001)
			keep year p
			g thr = 0
			g b=.
			append using y0_`typeincome'_temp 
			sort year p  
			drop thr b
			rename p y0
			if(inlist("`typeincome'","irpp","irpp_equal","irpp_foy","pretaxCN","pretaxCN_equal","pretaxCN_foy")){
				save "$projdir\Pareto interpolations\r_`typeincome'\y0_r_`typeincome'", replace
			}
			if(inlist("`typeincome'","cap","trav_FICN","trav_pretaxCN","trav_pretaxCN_equal")){
				save "$projdir\Pareto interpolations\r`typeincome'\y0_r`typeincome'", replace
			}
			erase y0_`typeincome'_temp.dta
		restore	
		
		
		keep dperc p* thr* b* `typeincome'* a* ytop* ratio_p* share* sum_ytop* y0*
		reshape long p thr b `typeincome' a ytop ratio_p share_dperc share_top sum_ytop y0, i(dperc) j(year)
		sort year dperc
		order dperc year `typeincome' p thr a b ytop ratio_p share_dperc share_top sum_ytop y0
		rename `typeincome' average
		replace b=. if b==0
		replace thr=0 if missing(thr)
		br
		bys year: gen t2=y0
		br		
		
		replace ytop = average/(1-p) if missing(ytop) & p==t2
		bys year p: drop if _n==2

		bys year: gen yint = (((1-p)*(ytop))-(1-p[_n+1])*(ytop[_n+1]))/(p[_n+1]-p)
		bys year: replace yint = ytop if d==999
		
		sort year p
		bys year: replace sum_ytop=sum_ytop[_n-1] if missing(sum_ytop) & p<=t2
		bys year: replace share_top=share_top[_n-1] if missing(share_top) & p<=t2
		drop if p==t2 & (missing(yint))
		reshape  wide average thr a b t2 ratio_p ytop share_dperc dperc yint sum_ytop share_top, i(p) j(year)
		br p dperc* thr* t2* yint* sum_ytop* ytop*
		
		forvalue year=2013/2014{
			*retreatment for missing yint
			replace yint`year'=(sum_ytop`year'-sum_ytop`year'[_n+1])/(p[_n+1]-p) if missing(yint`year')
			replace yint`year'=yint`year'[_n-1] if missing(yint`year')
			replace thr`year'=0 if (missing(thr`year')) 
		}
		*** 0 changes ***
		
		forvalue year = 2013/2014{
			local yearn1 = `year'-1
			*interpolation missing threshold
			replace thr`year' = thr`yearn1'*0.5*(yint`year'[_n-1]/yint`yearn1'[_n-1] + yint`year'/yint`yearn1') if (p>t2`year'&!missing(t2`year') & t2`year'>=t2`yearn1')
			replace b`year' =  ytop`year'/thr`year' if (p>t2`year'&!missing(t2`year') & t2`year'>=t2`yearn1')
		
			replace thr`year' = thr`yearn1'*0.5*(yint`year'[_n-1]/yint`yearn1'[_n-1] + yint`year'/yint`yearn1') if (p>t2`yearn1'&!missing(t2`year') & t2`year'<t2`yearn1')
			replace b`year' =  ytop`year'/thr`year' if (p>t2`yearn1'&!missing(t2`year') & t2`year'<t2`yearn1')
			
		}
		
		keep p* thr* b* a* ytop* share* dperc* yint* sum_ytop* t2*
		reshape long thr b a average ytop share_dperc dperc yint sum_ytop t2, i(p) j(year)
		sort year p
		order year p thr a b average ytop share_dperc dperc yint sum_ytop t2
		replace b=. if b==0
		replace thr=0 if missing(thr)
		sort year p thr
		br
		drop if missing(t2)
		sort year p thr
		replace p=t2 if p==0 & thr==0
		
		bys year: g t=_n
		bys year: g tb=_N
		xtset year t
		replace average = L.average if missing(average) &  p>0
		replace average = F.average if missing(average) &  p>0 & t<tb
		drop t tb
		
		keep if p>=t2
		drop if thr==0 & p>t2
		keep year average p thr b
		order year average p thr b
		save temp_fin_`typeincome'_2013_2014,replace
		

	forvalue i=2013/2014{
	export_results `typeincome' `i'
	}
	erase temp_fin_`typeincome'_2013_2014.dta
	capture erase temp.dta
end

/*** 2nd part : Launching of the programs ***/

complete irpp
complete irpp_equal
complete irpp_foy
complete pretaxCN
complete pretaxCN_equal
complete pretaxCN_foy

complete2 cap
complete2 trav_FICN
complete2 trav_pretaxCN
complete2 trav_pretaxCN_equal

/** Adding 2013 & 2014 **/

/** Programs complete or complete2 must have been launched before
to generate the y0_temp files **/
interpolation_income3 irpp
interpolation_income3 irpp_equal
interpolation_income3 irpp_foy

interpolation_income3 pretaxCN
interpolation_income3 pretaxCN_equal
interpolation_income3 pretaxCN_foy

interpolation_income3 cap
interpolation_income3 trav_FICN
interpolation_income3 trav_pretaxCN
interpolation_income3 trav_pretaxCN_equal



***** Average by year *******
* From WealthAppendixB, TB1

